
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*               Januar 2019                         *
*****************************************************

*****************************************************
* Maximum-Likelihood Schätzung
*****************************************************

/*------------------------------------------
*   Laden der Ado-Files des Programmpaketes
*
*        SPost (Stata Postestimation)
*
* Diese Ados werden im Buch von Long/Freese (2014)
* ausführlich beschrieben und werden im Folgenden
* häufiger verwendet. Zum installieren dieser Ados
* muss folgender Befehl abgesetzt werden: 
*------------------------------------------
net install spost9_ado.pkg
*/


clear 
set more off
version 15

* Daten: ALLBUS 2002
cd "C:\Users\bruederl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\"
use  AllbReg, clear


* ---------------------------------------
* Datenaufbereitung
* ---------------------------------------
* Nur 30 - 65 Jährige
keep if alter>29 & alter<66


*------------------------------------
*           Ein Logit Modell
* Bsp.: Arbeitslosigkeit die letzen 10 Jahre 
*------------------------------------

* set cformat %9.2f  //Format der Koeffizienten, S.E., KI 
* set pformat %5.3f  //Format des p-Wert

logit arblos bild alter frau ost


* Schätzoptionen
logit arblos bild alter frau ost, nolog        //ohne Iterationsprotokoll
logit arblos bild alter frau ost, level(90)    //90%-KI
logit arblos bild alter frau ost, vce(robust)  //robuste Standardfehler


* Standardisierte Koeffizienten
logit arblos bild alter frau ost
listcoef, help           //funktioniert nur, wenn SPost Ados geladen sind


* Estimation statistics
estat ic
estat summarize
estat vce


* Tests für komplexere Hypothesen
logit arblos bild frau ost
estimates store null

logit arblos bild frau ost alter c.alter#c.alter
estimates store full

test alter alter#alter     //Wald Test
lrtest null full           //LR-Test


* Verschiedene Fit-Statistiken
logit arblos bild alter frau ost
fitstat                 //funktioniert nur, wenn SPost Ados geladen sind

regress arblos bild alter frau ost   //zum Vergleich R2


* Modellvergleich mit BIC
logit arblos bild frau ost
fitstat, saving(mod1)             //funktioniert nur, wenn SPost Ados geladen sind

logit arblos bild frau ost alter c.alter#c.alter
fitstat, using(mod1)             //funktioniert nur, wenn SPost Ados geladen sind

